/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3545;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.network.NetworkPath;
import org.antarcticgardens.cna.util.HashSortedPair;

public class NetworkPathConductivityContext {
    private final Map<HashSortedPair<ElectricalConnectorBlockEntity>, class_3545<Long, Long>> connections = new HashMap<HashSortedPair<ElectricalConnectorBlockEntity>, class_3545<Long, Long>>();

    public NetworkPathConductivityContext() {
    }

    public NetworkPathConductivityContext(NetworkPathConductivityContext context) {
        for (Map.Entry<HashSortedPair<ElectricalConnectorBlockEntity>, class_3545<Long, Long>> e : context.connections.entrySet()) {
            this.connections.put(e.getKey(), (class_3545<Long, Long>)new class_3545((Object)((Long)e.getValue().method_15442()), (Object)((Long)e.getValue().method_15441())));
        }
    }

    public void addConnection(ElectricalConnectorBlockEntity node, ElectricalConnectorBlockEntity node1) {
        if (!((Object)((Object)node)).equals((Object)node1) && !this.connections.containsKey(new HashSortedPair<ElectricalConnectorBlockEntity>(node, node1))) {
            this.connections.put(new HashSortedPair<ElectricalConnectorBlockEntity>(node, node1), (class_3545<Long, Long>)new class_3545((Object)node.getConnectedConnectors().get((Object)node1).getConductivity(), (Object)0L));
        }
    }

    protected long calculatePathConductivity(NetworkPath path) {
        ElectricalConnectorBlockEntity prevNode = null;
        long conductivity = Long.MAX_VALUE;
        for (ElectricalConnectorBlockEntity node : path.getNodes()) {
            if (prevNode == null) {
                prevNode = node;
                continue;
            }
            HashSortedPair<ElectricalConnectorBlockEntity> key = new HashSortedPair<ElectricalConnectorBlockEntity>(prevNode, node);
            if (!this.connections.containsKey(key)) {
                return 0L;
            }
            long connectionConductivity = (Long)this.connections.get(key).method_15441();
            conductivity = Math.min(connectionConductivity, conductivity);
            prevNode = node;
        }
        return conductivity;
    }

    protected void decreasePathConductivity(NetworkPath path, long amount) {
        ElectricalConnectorBlockEntity prevNode = null;
        for (ElectricalConnectorBlockEntity node : path.getNodes()) {
            if (prevNode == null) {
                prevNode = node;
                continue;
            }
            HashSortedPair<ElectricalConnectorBlockEntity> key = new HashSortedPair<ElectricalConnectorBlockEntity>(prevNode, node);
            long connectionConductivity = (Long)this.connections.get(key).method_15441();
            this.connections.get(key).method_34965((Object)(connectionConductivity - amount));
            prevNode = node;
        }
    }

    protected long getConnectionConductivity(HashSortedPair<ElectricalConnectorBlockEntity> key) {
        return (Long)this.connections.get(key).method_15441();
    }

    protected void updateConductivity() {
        for (Map.Entry<HashSortedPair<ElectricalConnectorBlockEntity>, class_3545<Long, Long>> e : this.connections.entrySet()) {
            this.connections.get(e.getKey()).method_34965((Object)((Long)e.getValue().method_15442()));
        }
    }
}

